<?php
require 'auth.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/* =========================
   LOAD EMAIL FOR EDIT-AS-NEW
   ========================= */
$editEmail = $_SESSION['edit_email'] ?? null;
unset($_SESSION['edit_email']);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Compose Email</title>

<!-- TinyMCE -->
<script src="https://cdn.tiny.cloud/1/7drkqbwj7yfo5to3f34ud0kyqqfdwbo67dgh0mf1kxc5o1rb/tinymce/6/tinymce.min.js"></script>
<script>
tinymce.init({
    selector: '#html_content',
    height: 280,
    mobile: {
        menubar: false
    },
    plugins: 'link lists code',
    toolbar: 'bold italic | bullist numlist | link | code'
});
</script>

<style>
body {
    font-family: Arial, sans-serif;
    background: #f2f2f2;
    margin: 0;
}
.container {
    max-width: 1000px;
    margin: auto;
    background: #fff;
    padding: 20px;
}
.top-bar {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
    gap: 10px;
    margin-bottom: 15px;
}
.top-bar a {
    text-decoration: none;
    color: #0066ff;
    font-weight: bold;
}
label {
    font-weight: bold;
    margin-top: 12px;
    display: block;
}
input, textarea {
    width: 100%;
    padding: 12px;
    font-size: 16px;
    margin-top: 6px;
}
button {
    margin-top: 20px;
    width: 100%;
    padding: 14px;
    font-size: 18px;
    background: #0066ff;
    color: #fff;
    border: none;
    border-radius: 4px;
}
.status {
    padding: 12px;
    margin-bottom: 15px;
    border-radius: 4px;
    color: #fff;
}
.success { background: #28a745; }
.error { background: #dc3545; }

/* Desktop improvements */
@media (min-width: 768px) {
    .grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 15px;
    }
    button {
        width: auto;
        padding: 12px 40px;
    }
}
</style>
</head>

<body>

<div class="container">

<div class="top-bar">
    <div>👤 <?= htmlspecialchars($_SESSION['user']) ?></div>
    <div>
        <a href="sent_emails.php">Sent</a> |
        <a href="logout.php">Logout</a>
    </div>
</div>

<h2>Compose Email</h2>

<?php if (isset($_SESSION['status'])): ?>
<div class="status <?= $_SESSION['status']['type'] ?>">
    <?= htmlspecialchars($_SESSION['status']['msg']) ?>
</div>
<?php unset($_SESSION['status']); endif; ?>

<form action="send_email.php" method="POST" enctype="multipart/form-data">

<div class="grid">
    <div>
        <label>From Email</label>
        <input name="from_email" required
               value="<?= htmlspecialchars($editEmail['from'] ?? '') ?>">
    </div>
    <div>
        <label>From Name</label>
        <input name="from_name"
               value="<?= htmlspecialchars($editEmail['from_name'] ?? '') ?>">
    </div>
</div>

<label>Reply-To</label>
<input name="reply_to"
       value="<?= htmlspecialchars($editEmail['reply_to'] ?? '') ?>">

<label>To</label>
<input name="to" required
       value="<?= htmlspecialchars($editEmail['to'] ?? '') ?>">

<div class="grid">
    <div>
        <label>CC</label>
        <input name="cc"
               value="<?= htmlspecialchars($editEmail['cc'] ?? '') ?>">
    </div>
    <div>
        <label>BCC</label>
        <input name="bcc"
               value="<?= htmlspecialchars($editEmail['bcc'] ?? '') ?>">
    </div>
</div>

<label>Subject</label>
<input name="subject" required
       value="<?= htmlspecialchars($editEmail['subject'] ?? '') ?>">

<label>Email Body</label>
<textarea id="html_content" name="html_content">
<?= htmlspecialchars($editEmail['body'] ?? '') ?>
</textarea>

<label>Attachments</label>
<input type="file" name="attachments[]" multiple>

<button type="submit">
    <?= $editEmail ? 'Send Email Again' : 'Send Email' ?>
</button>

</form>

</div>
</body>
</html>
