<?php
require 'auth.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Only admin can delete
if ($_SESSION['user'] !== 'admin') {
    exit('Unauthorized');
}

if (!isset($_GET['id'])) {
    header('Location: sent_emails.php');
    exit;
}

$id = $_GET['id'];
$logFile = __DIR__ . '/logs/emails.json';

if (!file_exists($logFile)) {
    exit('Log file missing');
}

$emails = json_decode(file_get_contents($logFile), true) ?? [];

$newEmails = [];
$found = false;

foreach ($emails as $email) {

    if (isset($email['id']) && $email['id'] === $id) {
        $found = true;

        // 🗑️ DELETE ATTACHMENTS IF ANY
        if (!empty($email['attachments'])) {

            // All attachments share the same folder
            $first = $email['attachments'][0]['path'];
            $folder = dirname(__DIR__ . '/' . $first);

            if (is_dir($folder)) {
                foreach (glob($folder . '/*') as $file) {
                    if (is_file($file)) {
                        unlink($file);
                    }
                }
                rmdir($folder);
            }
        }

        continue;
    }

    $newEmails[] = $email;
}

if ($found) {
    file_put_contents(
        $logFile,
        json_encode($newEmails, JSON_PRETTY_PRINT)
    );
}

header('Location: sent_emails.php');
exit;
