<?php
require 'auth.php';

if (!isset($_GET['id'])) {
    header('Location: sent_emails.php');
    exit;
}

$logFile = __DIR__ . '/logs/emails.json';
if (!file_exists($logFile)) {
    exit('Log file missing');
}

$id = $_GET['id'];
$emails = json_decode(file_get_contents($logFile), true) ?? [];

foreach ($emails as $email) {
    if ($email['id'] === $id) {

        // Admin OR owner can edit
        if ($_SESSION['user'] !== 'admin' && $email['user'] !== $_SESSION['user']) {
            exit('Unauthorized');
        }

        // Store once, then redirect
        $_SESSION['edit_email'] = $email;
        header('Location: composer.php');
        exit;
    }
}

exit('Email not found');
