<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!empty($_SESSION['logged_in'])) {
    header('Location: composer.php');
    exit;
}

$users = require __DIR__ . '/users.php';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (isset($users[$username]) && password_verify($password, $users[$username]['password'])) {
        $_SESSION['logged_in'] = true;
        $_SESSION['user'] = $username;
        header('Location: composer.php');
        exit;
    } else {
        $error = 'Invalid username or password';
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login</title>

<style>
body {
    font-family: Arial, sans-serif;
    background: #f2f2f2;
    margin: 0;
}
.login-box {
    max-width: 420px;
    margin: 10vh auto;
    background: #fff;
    padding: 24px;
    border-radius: 8px;
}
h2 {
    text-align: center;
    margin-bottom: 20px;
}
input, button {
    width: 100%;
    padding: 14px;
    margin-top: 12px;
    font-size: 16px;
}
button {
    background: #0066ff;
    color: #fff;
    border: none;
    border-radius: 4px;
}
button:active {
    opacity: 0.85;
}
.error {
    color: #dc3545;
    text-align: center;
    margin-bottom: 10px;
}
</style>
</head>

<body>

<div class="login-box">
    <h2>Email System</h2>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST">
        <input name="username" placeholder="Username" required>
        <input name="password" type="password" placeholder="Password" required>
        <button type="submit">Login</button>
    </form>
</div>

</body>
</html>
